/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.report;

import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmtwidgets.NamedValue;
import com.quantumdata.fmteditor.report.FmtReport;
import com.quantumdata.fmteditor.report.FmtTableEntry;
import com.quantumdata.fmteditor.report.FmtTableModel;
import com.quantumdata.std.QDUtil;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FmtTable
extends JTable
implements MouseListener,
MouseMotionListener,
TableColumnModelListener {
    private FmtTableModel m_model;
    private FontMetrics m_fontMetrics = null;
    private int m_maxH = 1;
    private FmtValueRenderer m_renderer = new FmtValueRenderer();
    private int m_rolloverColIndex = -1;
    private static Icon[] m_icons = null;

    public FmtTable() {
        if (m_icons == null) {
            m_icons = new Icon[3];
            FmtTable.m_icons[0] = QDUtil.loadIcon((String)"noSort.png");
            FmtTable.m_icons[1] = QDUtil.loadIcon((String)"sortUp.png");
            FmtTable.m_icons[2] = QDUtil.loadIcon((String)"sortDown.png");
        }
        this.setBorder(BorderFactory.createLineBorder(QDStdUI.getActionForeground()));
        this.getSelectionModel().setSelectionMode(0);
        this.setAutoscrolls(true);
        this.m_model = new FmtTableModel();
        this.setModel(this.m_model);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new FmtTableHdrRenderer());
        jTableHeader.setResizingAllowed(true);
        jTableHeader.setForeground(QDStdUI.getActionForeground());
        jTableHeader.setBackground(QDStdUI.getButtonDark());
        jTableHeader.setAutoscrolls(true);
        jTableHeader.addMouseListener(this);
        jTableHeader.addMouseMotionListener(this);
        this.getColumnModel().addColumnModelListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
        if (n != this.m_rolloverColIndex) {
            this.m_rolloverColIndex = n;
            jTableHeader.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_rolloverColIndex == -1) {
            return;
        }
        this.m_rolloverColIndex = -1;
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        jTableHeader.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            this.sort(jTableHeader.columnAtPoint(mouseEvent.getPoint()));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
        if (n != this.m_rolloverColIndex) {
            this.m_rolloverColIndex = n;
            jTableHeader.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.configure();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void sort(int n) {
        if (n < 0) {
            return;
        }
        this.m_model.sortOnColumn(this.convertColumnIndexToModel(n));
    }

    public void configureHeader() {
        if (this.m_fontMetrics != null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        this.m_fontMetrics = graphics2D.getFontMetrics();
        this.configure();
    }

    private void configure() {
        if (this.m_fontMetrics == null) {
            return;
        }
        Vector<CmdValue> vector = this.m_model.getColumnValues();
        int n = this.getColumnCount();
        int n2 = 0;
        int n3 = 8 + m_icons[0].getIconWidth();
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(this.m_renderer);
            tableColumn.setResizable(true);
            String string = (String)tableColumn.getHeaderValue();
            String[] stringArray = string.split(" ");
            int n6 = stringArray.length;
            int n7 = 1;
            if (n6 > this.m_maxH) {
                this.m_maxH = n6;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = this.m_fontMetrics.stringWidth(stringArray[n5]) + n3;
                if (n4 <= n7) continue;
                n7 = n4;
            }
            n5 = this.convertColumnIndexToModel(i);
            if (n5 == 0) {
                n4 = this.m_fontMetrics.stringWidth("##############") + n3;
                if (n4 > n7) {
                    n7 = n4;
                }
            } else {
                CmdValue cmdValue = vector.get(n5 - 1);
                switch (cmdValue.getType()) {
                    case DOUBLE: {
                        n4 = this.m_fontMetrics.stringWidth("88888.88888") + n3;
                        if (n4 <= n7) break;
                        n7 = n4;
                        break;
                    }
                    case INT: {
                        if (cmdValue.isEnum()) {
                            for (NamedValue namedValue : cmdValue.getEnumValues()) {
                                n4 = this.m_fontMetrics.stringWidth(namedValue.name()) + n3;
                                if (n4 <= n7) continue;
                                n7 = n4;
                            }
                            break;
                        }
                        n4 = this.m_fontMetrics.stringWidth("00000000") + n3;
                        if (n4 <= n7) break;
                        n7 = n4;
                    }
                }
            }
            if (n7 > 200) {
                n7 = 200;
            }
            tableColumn.setPreferredWidth(n7);
            tableColumn.setMinWidth(n7);
            n2 += n7;
        }
    }

    public FmtTableModel getData() {
        return this.m_model;
    }

    public void saveTo(FmtReport fmtReport) {
        String[] stringArray = new String[this.m_model.getColumnValues().size()];
        int n = 0;
        for (CmdValue cmdValue : this.m_model.getColumnValues()) {
            stringArray[n] = cmdValue.getName();
            ++n;
        }
        fmtReport.setColNames(stringArray);
        Object object = new int[stringArray.length];
        for (n = 0; n < ((Object)object).length; ++n) {
            object[n] = this.convertColumnIndexToView(n + 1);
        }
        fmtReport.setColIndexes((int[])object);
        fmtReport.clearRows();
        for (n = 0; n < this.m_model.getRowCount(); ++n) {
            fmtReport.addRow(this.m_model.getEntry(n));
        }
    }

    public void restoreFrom(FmtReport fmtReport) {
        int n;
        this.m_model.clear();
        this.m_model.clearColumns();
        String[] object = fmtReport.getColNames();
        int tableColumnModel = object.length;
        for (n = 0; n < tableColumnModel; ++n) {
            String string = object[n];
            this.m_model.addColumn(string);
        }
        for (FmtReport.Row row : fmtReport.getRows()) {
            this.m_model.addRow(row);
        }
        this.m_model.entriesCompleted();
        int[] nArray = fmtReport.getColIndexes();
        if (nArray != null) {
            TableColumnModel tableColumnModel2 = this.getColumnModel();
            for (n = 1; n <= nArray.length; ++n) {
                int n2 = nArray[n - 1];
                int n3 = this.convertColumnIndexToView(n);
                if (n2 == n3) continue;
                tableColumnModel2.moveColumn(n3, n2);
            }
        }
    }

    private class FmtValueRenderer
    extends JLabel
    implements TableCellRenderer {
        public FmtValueRenderer() {
            super("");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FmtTableEntry fmtTableEntry = FmtTable.this.m_model.getEntry(n);
            this.setBorder(null);
            this.setOpaque(true);
            this.setBackground(QDStdUI.getBackground());
            this.setText((String)object);
            int n3 = jTable.convertColumnIndexToModel(n2);
            switch (n3) {
                case 0: {
                    this.setForeground(QDStdUI.getActionForeground());
                    this.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.setForeground(Color.white);
                    if (fmtTableEntry.getValue(n3 - 1).isEnum()) {
                        this.setHorizontalAlignment(2);
                        break;
                    }
                    this.setHorizontalAlignment(0);
                }
            }
            if (bl) {
                this.setBackground(QDStdUI.getSelectedColor());
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    private class FmtTableHdrRenderer
    extends DefaultTableCellRenderer {
        private Border normalBorder = BorderFactory.createLineBorder(QDStdUI.getActionForeground().darker());
        private Border focusBorder = BorderFactory.createLineBorder(QDStdUI.getSelectedColor());

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                this.setFont(jTableHeader.getFont());
            }
            if (n2 == FmtTable.this.m_rolloverColIndex) {
                this.setForeground(QDStdUI.getSelectedColor());
            } else {
                this.setForeground(QDStdUI.getActionForeground());
            }
            this.setBackground(QDStdUI.getButtonDark());
            this.setHorizontalAlignment(0);
            if (FmtTable.this.m_fontMetrics != null) {
                this.setPreferredSize(new Dimension(1, FmtTable.this.m_fontMetrics.getHeight() * FmtTable.this.m_maxH));
            }
            String string = "";
            if (object != null) {
                object2 = new StringBuffer("<HTML><p align=\"center\">");
                String[] stringArray = ((String)object).split(" ");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)object2).append("<br>");
                    }
                    ((StringBuffer)object2).append(stringArray[i]);
                }
                ((StringBuffer)object2).append("</p></HTML>");
                string = ((StringBuffer)object2).toString();
            }
            this.setText(string);
            if (n2 == FmtTable.this.m_rolloverColIndex) {
                this.setBorder(this.focusBorder);
            } else {
                this.setBorder(this.normalBorder);
            }
            object2 = null;
            int n3 = FmtTable.this.convertColumnIndexToModel(n2);
            switch (FmtTable.this.m_model.getSortMode(n3)) {
                case NONE: {
                    object2 = m_icons[0];
                    break;
                }
                case ASCENDING: {
                    object2 = m_icons[1];
                    break;
                }
                case DESCENDING: {
                    object2 = m_icons[2];
                }
            }
            this.setIcon((Icon)object2);
            if (n3 == 0) {
                this.setToolTipText("Format Name (double click to sort)");
            } else {
                CmdValue cmdValue = FmtTable.this.m_model.getColumnValues().get(n3 - 1);
                this.setToolTipText(cmdValue.getCmd() + " (double click to sort)");
            }
            return this;
        }
    }
}

